
# Auto Calibration App Note Example

import FXOS8700CQ
import aardvark_setup
from aardvark_py import *
import time
import math
from config import *

# Print Revision

print "AN4459 SW Rev: " + str(REVISION)

# Setup Aardvark

(handle, INT1_PIN) = aardvark_setup.setup_aardvark()

# Update aardvark handle in FXOS8700CQ.py

FXOS8700CQ.handle = handle

# Reset 

FXOS8700CQ.reset_FXOS8700CQ()

# Initialize debounce counter for reset

autoCalResetCtr = 0

# Set threshold. 1000 counts = 100.0uT

magThreshold = 1000 # counts
magThresholdHi = (magThreshold & 0xFF00) >> 8
magThresholdLo = magThreshold & 0xFF

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x6A, 0x80 | magThresholdHi] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x6B, magThresholdLo] )

# M_VECM_CNT = 1 * 20ms  = 20ms
# ! - steps double in hybrid mode

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x6C, 0x01] )

# M_VECM_CFG
# m_vecm_ele = 1 => event latching enabled
# m_vecm_initm = 1 => use M_VECM_INITX/Y/Z as initial reference
# m_vecm_updm = 1 => do not update initial reference
# m_vecm_en = 1 => enable magnetometer vector magnitude detection feature

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x69, 0x7B] )

# enable interrupts for DRDY using CTRL_REG4

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x2D, 0x01] )

# route interrupts to INT1 pin using CTRL_REG5

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x2E, 0x01] )

# Setup device
# via M_CTRL_REG1 (0x5B): Hybrid mode, OS = 32, Auto Cal
# via M_CTRL_REG2 (0x5C): Hybrid auto increment, maxmin disable
# threshold
# via CTRL_REG1 (0x2A): ODR = 50Hz, ACTIVE mode

FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x5B, 0x9F] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x5C, 0x20] )
FXOS8700CQ.write_byte_FXOS8700CQ_chk( [0x2A, 0x29] )

# Wait for INT1 to assert and clear interrupt by reading register INT_SOURCE 
# (0x0C) or reading sensor data (0x01...0x06, 0x33...0x38) depending on the 
# function that generated the interrupt

while( True ):
            
    # Check INT1 pin for interrupts
    
    transition = aa_gpio_change( handle, 100 )
    if (transition & INT1_PIN ) == INT1_PIN:
        #print "No interrupt..."
        continue			
            
    print "\nODR cycle ==============>\n"

    # Check if interrupt is due to Magnetometer Vector Magnitude
    
    (count, dataIn) = FXOS8700CQ.read_FXOS8700CQ( 0x5E, 1 )
    if dataIn[0] & 0x02 == 0x02:
            
        print "Interrupt due to Magnetometer Vector Magnitude feature"
        print "Magnetic Jamming detected"

        # Start debounce ctr
        
        autoCalResetCtr = autoCalResetCtr + 1
    
    else:
        
        autoCalResetCtr = 0 # reset counter               
        
    # Check if interrupt is due to Data Ready (DRDY)
    
    (count, dataIn) = FXOS8700CQ.read_FXOS8700CQ( 0x0C, 1 )
    if dataIn[0] & 0x01 == 0x01:
            
        print "Interrupt due to data ready"
                
        (magX, magY, magZ, accX, accY, accZ) = FXOS8700CQ.FXOS8700CQ_display_sens_data()

        # Apply HAL to match device coordinate system with NED
        # X matches, Z irrelevant
        
        magY = -magY				

        print "Magnetic Vector Magnitude = %4.1f uT" % (math.sqrt(
            magX * magX + magY * magY + magZ * magZ ) / 10)
        print "Heading ===> %.2f degrees from NORTH" % (math.atan2(
            -magY, magX ) * (180 / math.pi))
        
        # Reset Auto Cal based on debounce count

        if autoCalResetCtr > 10:
            
            print "Resetting Hard Iron Estimation..."

            FXOS8700CQ.write_FXOS8700CQ( 0x5C, [0x24] )
            autoCalResetCtr = 0 # reset counter

else:

    print "Wrong entry"

